﻿using System;
using System.IO;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using Google.Apis.Auth.OAuth2;

public partial class Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // URL에서 직접 호출되는 경우 처리
        string token = Request.QueryString["Token"];
        string title = Request.QueryString["title"];

        if (!string.IsNullOrEmpty(token) && !string.IsNullOrEmpty(title))
        {
            SendPushNotification(token, title).Wait();
        }
    }

    protected void btnSend_Click(object sender, EventArgs e)
    {
        // 입력된 Token과 Title 가져오기
        string token = txtToken.Text;
        string title = txtTitle.Text;

        if (!string.IsNullOrEmpty(token) && !string.IsNullOrEmpty(title))
        {
            SendPushNotification(token, title).Wait();
            lblMessage.Text = "메시지가 성공적으로 전송되었습니다!";
        }
        else
        {
            lblMessage.Text = "토큰과 제목을 입력하세요.";
        }
    }

    public async Task SendPushNotification(string token, string title)
    {
        string jsonPath = Server.MapPath("~/App_Data/firebase-service-account.json");
        string fcmUrl = "https://fcm.googleapis.com/v1/projects/pushing-99f8b/messages:send";

        // JSON Payload 생성
        string payload = $@"
        {{
            ""message"": {{
                ""token"": ""{token}"",
                ""notification"": {{
                    ""title"": ""{title}"",
                    ""body"": ""오늘의 세일을 확인하세요!""
                }}
            }}
        }}";

        // Access Token 생성
        string accessToken = GetAccessToken(jsonPath);

        // HTTP 요청 전송
        using (HttpClient client = new HttpClient())
        {
            client.DefaultRequestHeaders.Authorization = new System.Net.Http.Headers.AuthenticationHeaderValue("Bearer", accessToken);
            StringContent content = new StringContent(payload, Encoding.UTF8, "application/json");

            HttpResponseMessage response = await client.PostAsync(fcmUrl, content);
            string responseString = await response.Content.ReadAsStringAsync();
            lblMessage.Text = "FCM Response: " + responseString;
        }
    }

    private string GetAccessToken(string jsonPath)
    {
        var credential = GoogleCredential.FromFile(jsonPath)
            .CreateScoped("https://www.googleapis.com/auth/firebase.messaging");
        var accessToken = credential.UnderlyingCredential.GetAccessTokenForRequestAsync().Result;
        return accessToken;
    }
}
