
using System;
using System.IO;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using System.Web;
using Google.Apis.Auth.OAuth2;

public partial class Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string token = Request.QueryString["Token"];
        string title = Request.QueryString["title"];

        if (!string.IsNullOrEmpty(token) && !string.IsNullOrEmpty(title))
        {
            SendPushNotification(token, title).Wait();
        }
    }

    private async Task SendPushNotification(string token, string title)
    {
        string jsonPath = Server.MapPath("~/App_Data/firebase-service-account.json");
        string fcmUrl = "https://fcm.googleapis.com/v1/projects/YOUR_PROJECT_ID/messages:send";

        // JSON Payload
        string payload = $@"
        {{
            ""message"": {{
                ""token"": ""{token}"",
                ""notification"": {{
                    ""title"": ""{title}"",
                    ""body"": ""오늘의 세일을 확인하세요!""
                }}
            }}
        }}";

        // Access Token Generation
        string accessToken = GetAccessToken(jsonPath);

        // Send HTTP Request
        using (HttpClient client = new HttpClient())
        {
            client.DefaultRequestHeaders.Authorization = new System.Net.Http.Headers.AuthenticationHeaderValue("Bearer", accessToken);
            StringContent content = new StringContent(payload, Encoding.UTF8, "application/json");

            HttpResponseMessage response = await client.PostAsync(fcmUrl, content);
            string responseString = await response.Content.ReadAsStringAsync();
            //lblMessage.Text = "FCM Response: " + responseString;
        }
    }

    private string GetAccessToken(string jsonPath)
    {
        var credential = GoogleCredential.FromFile(jsonPath)
            .CreateScoped("https://www.googleapis.com/auth/firebase.messaging");
        var accessToken = credential.UnderlyingCredential.GetAccessTokenForRequestAsync().Result;
        return accessToken;
    }
}
