import random
from datetime import datetime, timedelta

from pytz import timezone

from app.extensions.utils.enum.jwt_enum import JWTEnum


def get_server_timestamp():
    return datetime.now(timezone("Asia/Seoul"))


def get_month_from_today():
    return datetime.now(timezone("Asia/Seoul")) - timedelta(days=30)


def get_str_from_today():
    return (
        datetime.now(timezone("Asia/Seoul")).strftime("%Y")
        + datetime.now(timezone("Asia/Seoul")).strftime("%m")
        + datetime.now(timezone("Asia/Seoul")).strftime("%d")
    )


def get_str_from_time():
    return datetime.now(timezone("Asia/Seoul")).strftime("%H") + datetime.now(
        timezone("Asia/Seoul")
    ).strftime("%M")


def get_month_from_date(date_from: str):
    """
        date_from example: 20210915
    """
    date = datetime.strptime(date_from, "%Y%m%d")
    return date - timedelta(days=30)


def get_random_date_about_one_month_from_today():
    """
        현재 날짜로부터 1달 이내 랜덤 날짜 구하기
    """
    start_date = get_month_from_today()
    end_date = get_server_timestamp()

    time_between_dates = end_date - start_date
    days_between_dates = time_between_dates.days
    random_number_of_days = random.randrange(days_between_dates)
    return start_date + timedelta(days=random_number_of_days)


def get_jwt_access_expired_timestamp() -> datetime:
    return get_server_timestamp() + timedelta(
        minutes=JWTEnum.ACCESS_TOKEN_EXPIRE_MINUTE.value
    )


def get_jwt_refresh_expired_timestamp() -> datetime:
    return get_server_timestamp() + timedelta(
        days=JWTEnum.REFRESH_TOKEN_EXPIRE_DAY.value
    )


def get_jwt_access_expired_time_delta() -> timedelta:
    return timedelta(minutes=JWTEnum.ACCESS_TOKEN_EXPIRE_MINUTE.value)


def get_jwt_refresh_expired_time_delta() -> timedelta:
    return timedelta(days=JWTEnum.REFRESH_TOKEN_EXPIRE_DAY.value)
