from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    DateTime,
    func,
    String,
)

from app import db


class BannedWordModel(db.Model):
    __tablename__ = "banned_words"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    word = Column(String(255), nullable=False)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
    updated_at = Column(
        DateTime(), server_default=func.now(), onupdate=func.now(), nullable=False
    )
