from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    String,
    DateTime,
    func,
    ForeignKey,
)

from app import db
from app.persistence.model.customer_inquiries import CustomerInquiryModel
from core.domains.cs.entity.cs_entity import InquiryAttachmentBaseEntity


class InquiryAttachmentModel(db.Model):
    __tablename__ = "inquiry_attachments"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    inquiry_id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        ForeignKey(CustomerInquiryModel.id),
        nullable=False,
        index=True,
    )
    uuid = Column(String(100), nullable=False)
    file_name = Column(String(100), nullable=False)
    path = Column(String(300), nullable=False)
    extension = Column(String(5), nullable=False)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
    updated_at = Column(
        DateTime(), server_default=func.now(), onupdate=func.now(), nullable=False
    )

    def to_entity(self) -> InquiryAttachmentBaseEntity:
        return InquiryAttachmentBaseEntity(
            id=self.id,
            inquiry_id=self.inquiry_id,
            uuid=self.uuid,
            file_name=self.file_name,
            path=self.path,
            extension=self.extension,
            created_at=self.created_at,
            updated_at=self.updated_at,
        )
