from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    String,
    DateTime,
    Boolean,
    func,
    ForeignKey,
)

from app import db
from app.persistence.model import UserModel
from core.domains.user.entity.user_entity import UserProfileEntity


class UserProfileModel(db.Model):
    __tablename__ = "user_profiles"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    user_id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        ForeignKey(UserModel.id),
        nullable=False,
        unique=True,
        index=True,
    )
    uuid = Column(String(100), nullable=False)
    file_name = Column(String(100), nullable=False)
    path = Column(String(300), nullable=False)
    extension = Column(String(5), nullable=False)
    is_available = Column(Boolean, nullable=False, default=True)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
    updated_at = Column(
        DateTime(), server_default=func.now(), onupdate=func.now(), nullable=False
    )

    def to_entity(self) -> UserProfileEntity:
        return UserProfileEntity(
            id=self.id,
            user_id=self.user_id,
            uuid=self.uuid,
            file_name=self.file_name,
            path=self.path,
            extension=self.extension,
            is_available=self.is_available,
        )
