from typing import List

from pydantic import BaseModel
from werkzeug.datastructures import FileStorage


class CreatePostAttachmentDto(BaseModel):
    post_id: int
    uuid: str
    file_name: str
    path: str
    extension: str
    object_name: str
    origin_file: FileStorage
    is_upload: bool

    class Config:
        arbitrary_types_allowed = True


class CreatePostDto(BaseModel):
    user_id: int
    post_category_id: int
    title: str | None = None
    body: str
    files: List


class UpdatePostDto(BaseModel):
    post_id: int
    user_id: int
    post_category_id: int
    title: str | None = None
    body: str
    files: List
    delete_files: List[int]


class DeletePostDto(BaseModel):
    post_id: int
    user_id: int


class GetPostDto(BaseModel):
    post_id: int


class UpdatePostLikeStatusDto(BaseModel):
    post_id: int
    user_id: int
    is_liked: bool


class CreateCommentDto(BaseModel):
    post_id: int
    user_id: int
    body: str


class UpdateCommentDto(BaseModel):
    comment_id: int
    user_id: int
    body: str


class DeleteCommentDto(BaseModel):
    comment_id: int
    user_id: int


class UpdateCommentLikeStatusDto(BaseModel):
    comment_id: int
    user_id: int
    is_liked: bool


class GetFeedsDto(BaseModel):
    user_id: int
    post_category_id: int
    previous_id: int | None


class GetNoticeDto(BaseModel):
    user_id: int
    post_category_id: int
    previous_id: int | None


class GetPushFeedDto(BaseModel):
    user_id: int
    post_id: int
    comment_id: int | None
    topic: str
