from sqlalchemy import exc

from sqlalchemy import exc

from app.extensions.database import session
from app.extensions.utils.log_helper import logger_
from app.persistence.model import CustomerInquiryModel, InquiryAttachmentModel
from core.domains.cs.dto.cs_dto import (
    CreateCustomerInquiryDto,
    CreateInquiryAttachmentDto,
)
from core.exceptions import NotUniqueErrorException

logger = logger_.getLogger(__name__)


class CSRepository:
    def create_customer_inquiry(self, dto: CreateCustomerInquiryDto) -> int | None:
        try:
            model = CustomerInquiryModel(
                user_id=dto.user_id, email=dto.email, title=dto.title, body=dto.body,
            )
            session.add(model)
            session.commit()

            return model.id
        except exc.IntegrityError as e:
            logger.error(
                f"[CSRepository][create_cs] user_id : {dto.user_id}, error : {e}"
            )
            session.rollback()
            raise NotUniqueErrorException

    def create_inquiry_attachment(self, dto: CreateInquiryAttachmentDto) -> None:
        try:
            model = InquiryAttachmentModel(
                inquiry_id=dto.inquiry_id,
                uuid=dto.uuid,
                file_name=dto.file_name,
                path=dto.path,
                extension=dto.extension,
            )
            session.add(model)
            session.commit()
        except exc.IntegrityError as e:
            logger.error(
                f"[CSRepository][create_inquiry_attachment] inquiry_id : {dto.inquiry_id} error : {e}"
            )
            session.rollback()
            raise NotUniqueErrorException
