
import json
import requests
from flask import Flask, request, jsonify, current_app
from google.oauth2 import service_account
from google.auth.transport.requests import Request
import logging

# Flask  
app = Flask(__name__)
app.config['FCM_PROJECT_ID'] = 'your-project-id'  # Firebase Ʈ ID
app.config['GOOGLE_APPLICATION_CREDENTIALS'] = 'path/to/service-account-file.json'  #    

# ΰ 
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

class FCM:
    @classmethod
    def get_access_token(cls) -> str:
        """OAuth2 ׼ ū """
        credentials_path = current_app.config.get("GOOGLE_APPLICATION_CREDENTIALS")
        credentials = service_account.Credentials.from_service_account_file(
            credentials_path,
            scopes=["https://www.googleapis.com/auth/cloud-platform"]
        )
        credentials.refresh(Request())
        return credentials.token

    @classmethod
    def send_message(cls, title: str, body: str, token: str, data: dict = None) -> bool:
        """FCM ˸ """
        try:
            access_token = cls.get_access_token()

            # HTTP v1 API URL 
            project_id = current_app.config.get("FCM_PROJECT_ID")
            url = f"https://fcm.googleapis.com/v1/projects/{project_id}/messages:send"

            # ޽ 
            message = {
                "message": {
                    "token": token,
                    "notification": {
                        "title": title,
                        "body": body
                    },
                    "data": data or {}
                }
            }

            #  
            headers = {
                "Authorization": f"Bearer {access_token}",
                "Content-Type": "application/json"
            }

            # POST û 
            response = requests.post(url, headers=headers, data=json.dumps(message))

            if response.status_code == 200:
                logger.info(f"޽  : {response.json()}")
                return True
            else:
                logger.error(f"޽  : {response.status_code}, {response.text}")
                return False

        except Exception as e:
            logger.error(f"[FCM][send_message] : {e}")
            return False

# ׽Ʈ API Ʈ
@app.route('/send_notification', methods=['POST'])
def send_notification():
    """FCM ˸  API"""
    data = request.json
    title = data.get('title')
    body = data.get('body')
    token = data.get('token')
    custom_data = data.get('data')

    if not title or not body or not token:
        return jsonify({"error": "title, body, and token are required"}), 400

    success = FCM.send_message(title, body, token, custom_data)
    if success:
        return jsonify({"message": "˸  "}), 200
    else:
        return jsonify({"error": "˸  "}), 500

if __name__ == '__main__':
    app.run(debug=True)
