from pydantic import (
    BaseModel,
    StrictInt,
    ValidationError,
    StrictStr,
)

from app.extensions.utils.log_helper import logger_
from core.domains.plant.dto.plant_dto import GetPlantMainDto, GetPlantDetailDto
from core.exceptions import InvalidRequestException

logger = logger_.getLogger(__name__)


class GetPlantMainSchema(BaseModel):
    user_id: StrictInt
    div: StrictStr


class GetPlantMainRequestSchema:
    def __init__(self, user_id: int, div: str):
        self.user_id = int(user_id) if user_id else None
        self.div = div

    def validate_request_and_make_dto(self):
        try:
            schema = GetPlantMainSchema(user_id=self.user_id, div=self.div).dict()
            return GetPlantMainDto(**schema)
        except ValidationError as e:
            logger.error(
                f"[GetPlantMainRequestSchema][validate_request_and_make_dto] error : {e}"
            )
            raise InvalidRequestException(message=e.errors())


class GetPlantDetailSchema(BaseModel):
    user_id: StrictInt
    div: StrictStr


class GetPlantDetailRequestSchema:
    def __init__(self, user_id: int, div: str):
        self.user_id = int(user_id) if user_id else None
        self.div = div

    def validate_request_and_make_dto(self):
        try:
            schema = GetPlantDetailSchema(user_id=self.user_id, div=self.div).dict()
            return GetPlantDetailDto(**schema)
        except ValidationError as e:
            logger.error(
                f"[GetPlantDetailRequestSchema][validate_request_and_make_dto] error : {e}"
            )
            raise InvalidRequestException(message=e.errors())
