from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    String,
    DateTime,
    func,
    ForeignKey,
    Numeric,
)

from app import db
from app.persistence.model.plant_profile_model import PlantProfileModel
from core.domains.plant.entity.plant_entity import PlantInfoEntity


class PlantInfoModel(db.Model):
    __tablename__ = "plant_infos"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    plant_id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        ForeignKey(PlantProfileModel.id),
        nullable=False,
        index=True,
    )
    sensormac = Column(String(30), nullable=False)
    interrupt = Column(String(100), nullable=False)
    temperature = Column(Numeric(4, 1), nullable=False)
    indoor_humidity = Column(Numeric(4, 1), nullable=False)
    soil_humidity = Column(Numeric(4, 1), nullable=False)
    illuminance = Column(Numeric(4, 1), nullable=False)
    created_date = Column(String(8), nullable=False, index=True)
    created_time = Column(String(4), nullable=False)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)

    def to_entity(self) -> PlantInfoEntity:
        return PlantInfoEntity(
            id=self.id,
            plant_id=self.plant_id,
            sensormac=self.sensormac,
            interrupt=self.interrupt,
            temperature=self.temperature,
            indoor_humidity=self.indoor_humidity,
            soil_humidity=self.soil_humidity,
            illuminance=self.illuminance,
            created_date=self.created_date,
            created_time=self.created_time,
            created_at=self.created_at,
        )
