
import json
import requests
from flask import Flask, request, jsonify, current_app
from google.oauth2 import service_account
from google.auth.transport.requests import Request
import logging
import os

# Flask 앱 설정
app = Flask(__name__)
app.config['FCM_PROJECT_ID'] = 'plantra-3dcb4'  # Firebase 프로젝트 ID
app.config['GOOGLE_APPLICATION_CREDENTIALS'] = 'E:/0.http_v1_push/0python/plantra-groot-00bfa51b59b5/httpv1/plantra.json'  # 서비스 계정 파일 경로

# 로거 설정
logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)

class FCM:
    @classmethod
    def get_access_token(cls) -> str:
        """OAuth2 액세스 토큰 생성"""
        credentials_path = current_app.config.get("GOOGLE_APPLICATION_CREDENTIALS")
        
        # 경로가 정확한지 확인
        if not os.path.exists(credentials_path):
            raise FileNotFoundError(f"JSON 파일이 존재하지 않습니다: {credentials_path}")
        else:
            print(f"JSON 파일이 정상적으로 존재합니다: {credentials_path}")


        credentials = service_account.Credentials.from_service_account_file(
            credentials_path,
            scopes=["https://www.googleapis.com/auth/cloud-platform"]
        )
        credentials.refresh(Request())
        return credentials.token

    @classmethod
    def send_message(cls, title: str, body: str, token: str, data: dict = None) -> bool:
        """FCM 알림 전송"""
        try:
            access_token = cls.get_access_token()

            # HTTP v1 API URL 구성
            project_id = current_app.config.get("FCM_PROJECT_ID")
            url = f"https://fcm.googleapis.com/v1/projects/{project_id}/messages:send"

            # 메시지 생성
            message = {
                "message": {
                    "token": token,
                    "notification": {
                        "title": title,
                        "body": body
                    },
                    "data": data or {}
                }
            }

            # 헤더 설정
            headers = {
                "Authorization": f"Bearer {access_token}",
                "Content-Type": "application/json"
            }

            # POST 요청 전송
            response = requests.post(url, headers=headers, data=json.dumps(message))

            if response.status_code == 200:
                logger.info(f"메시지 전송 성공: {response.json()}")
                return True
            else:
                logger.error(f"메시지 전송 실패: {response.status_code}, {response.text}")
                return False

        except Exception as e:
            logger.error(f"[FCM][send_message] 오류: {e}")
            return False

# 테스트용 API 라우트
@app.route('/send_notification', methods=['POST'])
def send_notification():
    """FCM 알림 전송 API"""
    data = request.json
    title = data.get('title')
    body = data.get('body')
    token = data.get('token')
    custom_data = data.get('data')

    if not title or not body or not token:
        return jsonify({"error": "title, body, and token are required"}), 400

    success = FCM.send_message(title, body, token, custom_data)
    if success:
        return jsonify({"message": "알림 전송 성공"}), 200
    else:
        return jsonify({"error": "알림 전송 실패"}), 500

# if __name__ == '__main__':
#     app.run(debug=True)

if __name__ == '__main__':
 # 애플리케이션 컨텍스트를 명시적으로 설정
    with app.app_context():
        test_title = "테스트 알림"
        test_body = "이것은 테스트 메시지입니다."
        test_token = "f9lH_mhpa06kmiKKXntp-k:APA91bEBScu9qDiBLi2973-zAgFdRlab1a1LmCpjFxtLttdcq93WBl2ykSo59s4ZeAQJhySn81kCb2FrWHGY7v4AudX0um3sPvzmxKxacXqsSILEMrR1qOrh7qi2Nqj7mR7awSPEGrFT"
        #test_token = "dYfW-qmLTpWRhTKK6tW6Qi:APA91bEU80JpVASyEs8EWYViFMkGNyt17OYwhpl-pniilu0xUOQdmaFyDlGovss9hdmA2tQilcXo1HHx0WlG8nnVpyJp87Y7MwT9geJwurVOH7NGG6G-xephLPqk2DOE3p-MMg3vjVVu"  # 여기에는 실제 FCM 디바이스 토큰을 입력해야 합니다.
        test_data = {
            "key1": "value1",
            "key2": "value2"
        }

        success = FCM.send_message(test_title, test_body, test_token, test_data)
    
        if success:
            print("테스트 메시지 전송 성공!")
        else:
            print("테스트 메시지 전송 실패.")

        # Flask 앱 실행
        app.run(debug=True)
