from flask import url_for

from core.domains.plant.enum.plant_enum import PlantCategoryEnum


def test_view_get_plant_categories_then_success(
    client,
    session,
    test_request_context,
    make_header,
    make_join_authorization,
    create_plant_cateroies,
):
    authorization = make_join_authorization()
    headers = make_header(
        authorization=authorization,
        content_type="application/json",
        accept="application/json",
    )

    with test_request_context:
        response = client.get(
            url_for("api/groot.get_plant_category_view"), headers=headers,
        )

    data = response.get_json()["data"]
    assert response.status_code == 200
    assert len(data["categories"]) == 4
    assert [
        category.get("name") for category in data["categories"]
    ] == PlantCategoryEnum.list()
