from unittest.mock import patch

from faker import Faker

from app.persistence.model import CustomerInquiryModel
from core.domains.cs.use_case.v1.cs_use_case import CreateCSUseCase
from core.use_case_output import UseCaseSuccessOutput

faker = Faker()


def test_us_create_cs_then_success(
    session, create_cs_dto, create_inquiry_attachment_dtos
):
    with patch(
        "core.domains.cs.use_case.v1.cs_use_case.CreateCSUseCase._get_file_split_object",
    ) as _get_file_split_object:
        _get_file_split_object.return_value = create_inquiry_attachment_dtos

        with patch(
            "core.domains.cs.use_case.v1.cs_use_case.CreateCSUseCase._upload_inquiry_attachments",
        ) as _upload_inquiry_attachments:
            create_inquiry_attachment_dto = create_inquiry_attachment_dtos[-1]
            create_inquiry_attachment_dto.is_upload = None

            _upload_inquiry_attachments.return_value = create_cs_dto

            result = CreateCSUseCase().execute(dto=create_cs_dto)

        query_result = session.query(CustomerInquiryModel).filter_by(id=1).first()

    assert isinstance(result, UseCaseSuccessOutput)
    assert query_result.body == create_cs_dto.body
    assert len(query_result.inquiry_attachments) == len(create_cs_dto.files) - 1


def test_us_create_cs_when_without_files_then_success(session, create_cs_dto):
    create_cs_dto.files = []
    result = CreateCSUseCase().execute(dto=create_cs_dto)

    assert isinstance(result, UseCaseSuccessOutput)
