from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    String,
    DateTime,
    ForeignKey,
)

from app import db
from app.persistence.model.user_model import UserModel
from app.extensions.utils.time_helper import get_jwt_access_expired_timestamp
from core.domains.user.entity.user_entity import BlacklistEntity


class BlacklistModel(db.Model):
    __tablename__ = "blacklists"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    user_id = Column(BigInteger, ForeignKey(UserModel.id), nullable=False, index=True)
    access_token = Column(String(280), nullable=False)
    expired_at = Column(
        DateTime(),
        nullable=False,
        default=get_jwt_access_expired_timestamp(),
        onupdate=get_jwt_access_expired_timestamp(),
    )

    def to_entity(self) -> BlacklistEntity:
        return BlacklistEntity(
            id=self.id,
            user_id=self.user_id,
            access_token=self.access_token,
            expired_at=self.expired_at,
        )
