from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    DateTime,
    func,
    ForeignKey,
    Boolean,
)

from app import db
from app.persistence.model.post_model import PostModel
from core.domains.community.entity.community_entity import PostLikeStatusEntity


class PostLikeStatusModel(db.Model):
    __tablename__ = "post_like_statuses"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    post_id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        ForeignKey(PostModel.id),
        nullable=False,
        index=True,
    )
    user_id = Column(
        BigInteger().with_variant(Integer, "sqlite"), nullable=False, index=True
    )
    is_liked = Column(Boolean, nullable=False)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
    updated_at = Column(
        DateTime(), server_default=func.now(), onupdate=func.now(), nullable=False
    )

    def to_entity(self) -> PostLikeStatusEntity:
        return PostLikeStatusEntity(
            id=self.id,
            post_id=self.post_id,
            user_id=self.user_id,
            is_liked=self.is_liked,
            created_at=self.created_at,
            updated_at=self.updated_at,
        )

    def owner_is_liked(self, user_id: int) -> bool:
        if self.user_id == user_id:
            return True
        return False
