from typing import List

from pydantic import BaseModel
from werkzeug.datastructures import FileStorage


class CreateAdminPostAttachmentDto(BaseModel):
    post_id: int
    uuid: str
    file_name: str
    path: str
    extension: str
    object_name: str
    origin_file: FileStorage
    is_upload: bool

    class Config:
        arbitrary_types_allowed = True


class CreateAdminPostDto(BaseModel):
    user_id: int
    post_category_id: int
    title: str | None = None
    body: str
    files: List


class UpdateAdminPostDto(BaseModel):
    post_id: int
    user_id: int
    post_category_id: int
    title: str | None = None
    body: str
    files: List
    delete_files: List[int]


class DeleteAdminPostDto(BaseModel):
    post_id: int
    user_id: int


class GetAdminPostDto(BaseModel):
    post_id: int
    user_id: int


class GetAdminFeedsDto(BaseModel):
    user_id: int
    post_category_id: int
    page_no: int | None
    target_user_id: int | None


class DeleteAdminCommentDto(BaseModel):
    comment_id: int
    user_id: int


class GetAdminUserDto(BaseModel):
    target_user_id: int | None
    page_no: int | None
    nickname: str | None
    user_id: int


class DeleteAdminUserDto(BaseModel):
    target_user_id: int
    user_id: int


class GetAdminCSDto(BaseModel):
    user_id: int
    is_solved: bool
    email: str | None
    page_no: int | None


class UpdateAdminCSDto(BaseModel):
    user_id: int
    inquiry_id: int
    is_solved: bool
