import os
from enum import Enum


class ExtendedEnum(Enum):
    @classmethod
    def list(cls):
        return list(map(lambda c: c.value, cls))


class ProviderEnum(ExtendedEnum):
    KAKAO = "kakao"
    GOOGLE = "google"
    APPLE = "apple"


class OAuthKakaoEnum(Enum):
    USER_INFO_END_POINT = "/v2/user/me"
    API_BASE_URL = "https://kapi.kakao.com"


class OAuthGoogleEnum(Enum):
    USER_INFO_URL = "https://openidconnect.googleapis.com/v1/userinfo"


class OAuthAppleEnum(Enum):
    FIREBASE_AUTH_URL = "https://www.googleapis.com/robot/v1/metadata/x509/securetoken@system.gserviceaccount.com"
    FIREBASE_AUDIENCE = os.environ.get("APPLE_FIREBASE_AUDIENCE") or ""
