from pydantic import BaseModel, UUID4
from werkzeug.datastructures import FileStorage


class UploadUserProfileImgDto(BaseModel):
    file: FileStorage

    class Config:
        arbitrary_types_allowed = True


class CreateUserProfileImgDto(BaseModel):
    uuid: str
    file_name: str
    path: str
    extension: str
    object_name: str
    origin_file: FileStorage

    class Config:
        arbitrary_types_allowed = True


class CreateUserDto(BaseModel):
    nickname: str
    email: str | None
    provider: str
    provider_id: str
    mobile_os: str
    start_growing_date: str
    plant_name: str
    plant_category_id: int
    private_user_info_yn: bool
    required_terms_yn: bool
    receive_marketing_yn: bool
    file_extension: str | None
    file_name: str | None
    file_path: str | None
    file_uuid: str | None
    login_uuid: str


class UpdateUserDto(BaseModel):
    user_id: int
    start_growing_date: str
    plant_category_id: int
    user_nickname: str
    plant_nickname: str
    file_extension: str | None
    file_name: str | None
    file_path: str | None
    file_uuid: str | None


class GetUserDto(BaseModel):
    user_id: int


class GetReceivePushTypeDto(BaseModel):
    user_id: int


class UpdateReceivePushTypeDto(BaseModel):
    user_id: int
    is_comment: bool
    is_like: bool
    is_incubator: bool


class UpdateDeviceDto(BaseModel):
    user_id: int
    hw_mac: str


class UpdateFCMTokenDto(BaseModel):
    user_id: int
    fcm_token: str


class GetMacDto(BaseModel):
    user_id: int
