"""alter timezone all tables

Revision ID: b2f0566e89b7
Revises: a194da2529f5
Create Date: 2022-07-22 10:55:59.769804

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
from sqlalchemy.dialects import postgresql

revision = "b2f0566e89b7"
down_revision = "a194da2529f5"
branch_labels = None
depends_on = None


def upgrade():
    # users
    op.alter_column(
        "users",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "users",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # notification_tokens
    op.alter_column(
        "notification_tokens",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "notification_tokens",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # devices
    op.alter_column(
        "devices",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "devices",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # receive_push_types
    op.alter_column(
        "receive_push_types",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "receive_push_types",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # notifications
    op.alter_column(
        "notifications",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "notifications",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # app_agree_terms
    op.alter_column(
        "app_agree_terms",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "app_agree_terms",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # plant_profiles
    op.alter_column(
        "plant_profiles",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "plant_profiles",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # plant_categories
    op.alter_column(
        "plant_categories",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "plant_categories",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # plant_infos
    op.alter_column(
        "plant_infos",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )

    # receive_failure_histoires
    op.alter_column(
        "receive_failure_histories",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )

    # customer_inquiries
    op.alter_column(
        "customer_inquiries",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "customer_inquiries",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # inquiry_attachments
    op.alter_column(
        "inquiry_attachments",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "inquiry_attachments",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # user_profiles
    op.alter_column(
        "user_profiles",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "user_profiles",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # posts
    op.alter_column(
        "posts",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "posts",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # comments
    op.alter_column(
        "comments",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "comments",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # comment_like_statuses
    op.alter_column(
        "comment_like_statuses",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "comment_like_statuses",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # post_categories
    op.alter_column(
        "post_categories",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "post_categories",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # post_attachments
    op.alter_column(
        "post_attachments",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "post_attachments",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # post_like_statuses
    op.alter_column(
        "post_like_statuses",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "post_like_statuses",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )

    # banned_words
    op.alter_column(
        "banned_words",
        "created_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
    )
    op.alter_column(
        "banned_words",
        "updated_at",
        server_default=sa.text("now()"),
        type_=postgresql.TIMESTAMP(timezone=True),
        onupdate=sa.func.now(),
    )


def downgrade():
    pass
