from sqlalchemy.orm import joinedload

from app.persistence.model import UserModel
from core.domains.user.entity.user_entity import UserEntity
from core.domains.user.repository.user_repository import UserRepository
from core.domains.user.use_case.v1.user_use_case import (
    CreateUserUseCase,
    UpdateUserUseCase,
)
from core.use_case_output import UseCaseSuccessOutput


# def test_us_create_user_then_success(session, create_user_dto):
#     result = CreateUserUseCase().execute(dto=create_user_dto)
#     assert isinstance(result, UseCaseSuccessOutput)


# def test_us_create_user_then_verifying_success(session, create_user_dto):
#     CreateUserUseCase().execute(dto=create_user_dto)
#     user: UserEntity | None = UserRepository().get_user_by_id(id=1)
#
#     assert isinstance(user, UserEntity)
#     assert user.email == create_user_dto.email
#     assert user.nickname == create_user_dto.nickname


def test_us_update_user_then_success(session, create_user, update_user_dto):
    update_user_dto.user_id = create_user.id
    result = UpdateUserUseCase().execute(dto=update_user_dto)

    query = (
        session.query(UserModel)
        .options(joinedload(UserModel.plant_profile, innerjoin=True))
        .filter_by(id=update_user_dto.user_id)
    )
    query_set = query.first()

    assert isinstance(result, UseCaseSuccessOutput)
    assert (
        update_user_dto.start_growing_date == query_set.plant_profile.start_growing_date
    )
    assert update_user_dto.file_path == query_set.user_profile.path
    assert update_user_dto.file_extension == query_set.user_profile.extension
    assert update_user_dto.file_name == query_set.user_profile.file_name
    assert update_user_dto.file_uuid == query_set.user_profile.uuid
