from typing import List

from pydantic import BaseModel, ValidationError, StrictInt, StrictStr
from werkzeug.datastructures import FileStorage

from app.extensions.utils.log_helper import logger_
from app.http.requests.v1.post_request import ImageListSchema
from core.domains.cs.dto.cs_dto import CreateCustomerInquiryDto
from core.exceptions import InvalidRequestException

logger = logger_.getLogger(__name__)


class CreateCSSchema(BaseModel):
    user_id: StrictInt
    title: StrictStr
    email: StrictStr
    body: StrictStr


class CreateCSRequest:
    def __init__(
        self, user_id, title, email, body, files,
    ):
        self.user_id = int(user_id) if user_id else None
        self.title = title
        self.email = email
        self.body = body
        self.files: List[FileStorage] = files

    def validate_request_and_make_dto(self):
        try:
            schema = CreateCSSchema(
                user_id=self.user_id,
                title=self.title,
                email=self.email,
                body=self.body,
            ).dict()

            file_list_schema = ImageListSchema(files=self.files)

            schema.update(file_list_schema.dict())
            return CreateCustomerInquiryDto(**schema)
        except ValidationError as e:
            logger.error(
                f"[CreateCSRequest][validate_request_and_make_dto] error : {e}"
            )
            raise InvalidRequestException(message=e.errors())
