from flask import request
from flask_jwt_extended import jwt_required

from app.http.requests.v1.plant_request import (
    GetPlantMainRequestSchema,
    GetPlantDetailRequestSchema,
)
from app.http.responses.presenters.v1.plant_presenter import (
    GetPlantCategoryPresenter,
    GetPlantMainPresenter,
    GetPlantDetailPresenter,
)
from app.http.view import api, auth_required, current_user
from core.domains.plant.use_case.v1.plant_use_case import (
    GetPlantCategoryUseCase,
    GetPlantMainUseCase,
    GetPlantDetailUseCase,
)


@api.route("/v1/plants/category", methods=["GET"])
@jwt_required
def get_plant_category_view():
    return GetPlantCategoryPresenter().transform(GetPlantCategoryUseCase().execute())


@api.route("/v1/plants/main", methods=["GET"])
@jwt_required
@auth_required
def get_plant_main_view():
    dto = GetPlantMainRequestSchema(
        div=request.args.get("div"), user_id=current_user.id
    ).validate_request_and_make_dto()
    return GetPlantMainPresenter().transform(GetPlantMainUseCase().execute(dto=dto))


@api.route("/v1/plants/detail", methods=["GET"])
@jwt_required
@auth_required
def get_plant_detail_view():
    dto = GetPlantDetailRequestSchema(
        div=request.args.get("div"), user_id=current_user.id
    ).validate_request_and_make_dto()
    return GetPlantDetailPresenter().transform(GetPlantDetailUseCase().execute(dto=dto))
