from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    DateTime,
    func,
    ForeignKey,
    Boolean,
)

from app import db
from app.persistence.model.comment_model import CommentModel
from core.domains.community.entity.community_entity import CommentLikeStatusEntity


class CommentLikeStatusModel(db.Model):
    __tablename__ = "comment_like_statuses"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    comment_id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        ForeignKey(CommentModel.id),
        nullable=False,
        index=True,
    )
    user_id = Column(
        BigInteger().with_variant(Integer, "sqlite"), nullable=False, index=True
    )
    is_liked = Column(Boolean, nullable=False)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
    updated_at = Column(
        DateTime(), server_default=func.now(), onupdate=func.now(), nullable=False
    )

    def to_entity(self) -> CommentLikeStatusEntity:
        return CommentLikeStatusEntity(
            id=self.id,
            comment_id=self.comment_id,
            user_id=self.user_id,
            is_liked=self.is_liked,
            created_at=self.created_at,
            updated_at=self.updated_at,
        )

    def owner_is_liked(self, user_id: int) -> bool:
        if self.user_id == user_id:
            return True
        return False
