from typing import List

from pydantic import BaseModel, StrictStr, StrictInt, StrictBool

from core.domains.community.entity.community_entity import AdminFeedEntity
from core.domains.cs.entity.cs_entity import CustomerInquiryEntity


class DefaultAdminResponseSchema(BaseModel):
    result: StrictStr


class GetAdminPostCategoryBaseSchema(BaseModel):
    id: StrictInt
    name: StrictStr


class GetAdminPostFileBaseSchema(BaseModel):
    id: StrictInt
    path: StrictStr


class GetAdminPostBaseSchema(BaseModel):
    id: StrictInt
    title: str | None
    body: StrictStr
    post_attachments: List[GetAdminPostFileBaseSchema] | None


class GetAdminPostResponseSchema(BaseModel):
    post: GetAdminPostBaseSchema
    post_categories: List[GetAdminPostCategoryBaseSchema]


class GetAdminFeedsResponseSchema(BaseModel):
    feeds: List[AdminFeedEntity] | None
    cursor: dict


class GetUserProfileBaseSchema(BaseModel):
    id: StrictInt
    path: StrictStr


class GetUserPlantProfileBaseSchema(BaseModel):
    name: StrictStr
    start_growing_date: StrictStr
    plant_category_id: StrictInt


class GetUserBaseSchema(BaseModel):
    id: StrictInt
    email: StrictStr | None
    provider: StrictStr
    join_date: StrictStr
    group: StrictStr
    nickname: StrictStr
    is_out: StrictBool
    is_available: StrictBool
    user_profile: GetUserProfileBaseSchema | None
    plant_profile: GetUserPlantProfileBaseSchema


class GetUserAdminResponseSchema(BaseModel):
    users: List[GetUserBaseSchema] | None
    cursor: dict


class GetAdminCSResponseSchema(BaseModel):
    cs: List[CustomerInquiryEntity] | None
    cursor: dict
