from typing import List

from pydantic import BaseModel, StrictStr, StrictInt

from core.domains.community.entity.community_entity import (
    FeedEntity,
    NoticeEntity,
    FeedCommentUserEntity,
)


class DefaultPostResponseSchema(BaseModel):
    result: StrictStr


class GetPostCategoryBaseSchema(BaseModel):
    id: StrictInt
    name: StrictStr


class GetPostCategoryResponseSchema(BaseModel):
    categories: List[GetPostCategoryBaseSchema]


class GetPostFileBaseSchema(BaseModel):
    id: StrictInt
    path: StrictStr


class GetPostBaseSchema(BaseModel):
    id: StrictInt
    title: str | None
    body: StrictStr
    post_attachments: List[GetPostFileBaseSchema]


class GetPostResponseSchema(BaseModel):
    post: GetPostBaseSchema
    post_categories: List[GetPostCategoryBaseSchema]


class GetFeedsResponseSchema(BaseModel):
    feeds: List[FeedEntity] | None
    cursor: dict


class CreateCommentBaseSchema(BaseModel):
    id: int
    body: str
    is_liked: bool
    is_owner: bool
    like_count: int
    user: FeedCommentUserEntity


class CreateCommentResponseSchema(BaseModel):
    comments: List[CreateCommentBaseSchema] | None


class GetNoticesResponseSchema(BaseModel):
    notices: List[NoticeEntity] | None
    cursor: dict
