from datetime import datetime
from typing import List

from pydantic import BaseModel


class InquiryAttachmentEntity(BaseModel):
    id: int
    path: str


class CustomerInquiryEntity(BaseModel):
    id: int
    user_id: int
    email: str
    title: str
    body: str
    is_solved: bool
    created_date: str
    create_diff_day: str | None
    created_at: datetime
    inquiry_attachments: List[InquiryAttachmentEntity] | None


class InquiryAttachmentBaseEntity(BaseModel):
    id: int
    inquiry_id: int
    uuid: str | None
    file_name: str | None
    path: str | None
    extension: str | None
    created_at: datetime
    updated_at: datetime
