from enum import Enum


class ExtendedEnum(Enum):
    @classmethod
    def list(cls):
        return list(map(lambda c: c.value, cls))


class PlantCategoryEnum(ExtendedEnum):
    HOUSE_PLANT = "관엽식물"
    HORTICULTURAL_PLANT = "원예식물"
    SUCCULENT_PLANT = "다육식물"
    VEGETABLE = "채소"


class TemperatureApprValueEnum(ExtendedEnum):
    HIGH = 30
    LOW = 16


class IndoorHumidityApprValueEnum(ExtendedEnum):
    HIGH = 80
    LOW = 30


class SoilHumidityApprValueEnum(ExtendedEnum):
    HIGH = 90
    LOW = 30


class IlluminanceApprValueEnum(ExtendedEnum):
    HIGH = 90
    LOW = 40


class TemperatureApprWordEnum(ExtendedEnum):
    HIGH = "주변 환경이 너무 덥습니다."
    APPR = "적절한 환경을 유지하고 있습니다."
    LOW = "주변 환경이 너무 차갑습니다."


class TemperatureApprEventEnum(ExtendedEnum):
    HIGH = ": 조금 더워요. 시원하게 해 주세요."
    APPR = ": 현재 편안한 상태입니다."
    LOW = ": 이제 곧 겨울인가요? 따뜻하게 해 주세요.!"


class IndoorHumidityApprWordEnum(ExtendedEnum):
    HIGH = "실내의 습기가 너무 높습니다."
    APPR = "쾌적한 습도입니다."
    LOW = "적절한 습도를 유지하고 있습니다."


class IndoorHumidityApprEventEnum(ExtendedEnum):
    HIGH = "주변의 습도를 낮추어 주세요."
    APPR = ": 지금 매우 쾌적하다고 생각해요."
    LOW = ": 현재 무난하게 잘 자라고 있어요."


class SoilHumidityApprWordEnum(ExtendedEnum):
    HIGH = "과습의 위험이 있습니다."
    APPR = "토양이 적당히 촉촉합니다."
    LOW = "물이 필요합니다."


class SoilHumidityApprEventEnum(ExtendedEnum):
    HIGH = " 주변의 토양이 조금 촉촉해요."
    APPR = " : 지금 같은 촉촉함이 딱 좋아요."
    LOW = " : 이제 목이 말라요."


class IlluminanceApprWordEnum(ExtendedEnum):
    HIGH = "빛이 조금 많습니다."
    APPR = "성장에 가장 적당한 조도입니다."
    LOW = "적당한 조도가 필요해요."


class IlluminanceApprEventEnum(ExtendedEnum):
    HIGH = "너무 쨍쨍해요!."
    APPR = ": 제가 가장 좋아하는 상태에요."
    LOW = "혹시 밤인가요? 어둡지만 아침까지 기다릴께요."
