from uuid import uuid4

import pytest

from app.http.requests.v1.oauth_request import GetOAuthLoginRequest
from core.domains.oauth.enum.oauth_enum import ProviderEnum
from core.exceptions import InvalidRequestException

uuid = str(uuid4())


def test_when_valid_request_with_kakao_then_success():
    result = GetOAuthLoginRequest(
        provider=ProviderEnum.KAKAO.value, provider_id="test1234", uuid=uuid
    ).validate_request_and_make_dto()
    assert result.provider == ProviderEnum.KAKAO.value


def test_when_valid_request_with_google_then_success():
    result = GetOAuthLoginRequest(
        provider=ProviderEnum.GOOGLE.value, provider_id="test1234", uuid=uuid
    ).validate_request_and_make_dto()
    assert result.provider == ProviderEnum.GOOGLE.value


def test_when_valid_request_with_apple_then_success():
    result = GetOAuthLoginRequest(
        provider=ProviderEnum.APPLE.value, provider_id="test1234", uuid=uuid
    ).validate_request_and_make_dto()
    assert result.provider == ProviderEnum.APPLE.value


def test_when_invalid_request_then_raise_validation_error():
    with pytest.raises(InvalidRequestException):
        GetOAuthLoginRequest(
            provider="hawaii", provider_id="test1234", uuid=uuid
        ).validate_request_and_make_dto()
