from enum import Enum

from core.domains.oauth.enum.oauth_enum import ExtendedEnum


class ImageSizeEnum(Enum):
    """
    ALLOWED_MAX_SIZE: 서버 허용 이미지 사이즈(10 MB = 10 * 1024 * 1024 bytes)
    """

    ALLOWED_MAX_SIZE_BYTES = 10 * 1024 * 1024
    ALLOWED_MAX_SIZE_MEGABYTES = 10


class ImageFormatEnum(ExtendedEnum):
    JPG = "jpg"
    JPEG = "jpeg"
    PNG = "png"
