from sqlalchemy import (
    Column,
    BigInteger,
    DateTime,
    Integer,
    String,
    func,
    Boolean,
)

from app import db
from core.domains.community.entity.community_entity import PostCategoryEntity


class PostCategoryModel(db.Model):
    __tablename__ = "post_categories"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    name = Column(String(30), nullable=False)
    is_available = Column(Boolean, nullable=False, default=True)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
    updated_at = Column(
        DateTime(), server_default=func.now(), onupdate=func.now(), nullable=False
    )

    def to_entity(self) -> PostCategoryEntity:
        return PostCategoryEntity(
            id=self.id, name=self.name, is_available=self.is_available,
        )
