from datetime import datetime
from typing import List

from pydantic import BaseModel


class PostCategoryEntity(BaseModel):
    id: int
    name: str
    is_available: bool


class CommentLikeStatusEntity(BaseModel):
    id: int
    comment_id: int
    user_id: int
    is_liked: bool
    created_at: datetime
    updated_at: datetime


class CommentEntity(BaseModel):
    id: int
    post_id: int
    user_id: int
    body: str
    is_deleted: bool
    like_count: int
    last_user_action: str
    last_user_action_at: datetime
    last_admin_action: str | None
    last_admin_action_at: datetime | None
    created_at: datetime
    updated_at: datetime
    comment_like_statuses: List[CommentLikeStatusEntity] | None


class PostLikeStatusEntity(BaseModel):
    id: int
    post_id: int
    user_id: int
    is_liked: bool
    created_at: datetime
    updated_at: datetime


class PostAttachmentEntity(BaseModel):
    id: int
    post_id: int
    uuid: str | None
    file_name: str | None
    path: str | None
    extension: str | None
    is_available: bool
    created_at: datetime
    updated_at: datetime


class PostEntity(BaseModel):
    id: int
    user_id: int
    title: str | None
    body: str
    is_deleted: bool
    like_count: int
    post_category_id: int
    last_user_action: str
    last_user_action_at: datetime
    last_admin_action: str | None
    last_admin_action_at: datetime | None
    created_at: datetime
    updated_at: datetime
    comments: List[CommentEntity] | None
    post_like_statuses: List[PostLikeStatusEntity] | None
    post_attachments: List[PostAttachmentEntity] | None
    post_category: PostCategoryEntity


class GetPostEntity(BaseModel):
    id: int
    body: str
    files: List[PostAttachmentEntity] | None


class FeedUserEntity(BaseModel):
    id: int
    nickname: str
    profile_img: str | None


class FeedCommentUserEntity(BaseModel):
    id: int
    nickname: str
    profile_img: str | None


class FeedCommentEntity(BaseModel):
    id: int
    body: str
    is_liked: bool
    is_owner: bool
    is_writer: bool
    like_count: int
    plant_nickname: str | None
    user: FeedCommentUserEntity


class AdminFeedCommentEntity(BaseModel):
    id: int
    body: str
    like_count: int
    plant_nickname: str | None
    user: FeedCommentUserEntity


class FeedPostAttachmentEntity(BaseModel):
    id: int
    path: str


class FeedEntity(BaseModel):
    id: int
    plant_nickname: str
    created_date: str
    category: str
    body: str
    title: str | None
    is_liked: bool
    is_owner: bool
    like_count: int
    comment_count: int
    create_diff_day: str | None
    post_attachments: List[FeedPostAttachmentEntity] | None
    user: FeedUserEntity
    created_at: datetime
    updated_at: datetime

    comments: List[FeedCommentEntity] | None


class AdminFeedEntity(BaseModel):
    id: int
    plant_nickname: str
    created_date: str
    category: str
    title: str | None
    body: str
    like_count: int
    comment_count: int
    create_diff_day: str | None
    created_at: datetime
    updated_at: datetime

    post_attachments: List[FeedPostAttachmentEntity] | None
    user: FeedUserEntity
    comments: List[AdminFeedCommentEntity] | None


class NoticeEntity(BaseModel):
    id: int
    title: str | None
    created_date: str
    create_diff_day: str | None
    body: str
    post_attachments: List[FeedPostAttachmentEntity] | None
    created_at: datetime
    updated_at: datetime
