from typing import List

from pydantic import BaseModel
from werkzeug.datastructures import FileStorage


class CreateCustomerInquiryDto(BaseModel):
    user_id: int
    title: str
    email: str
    body: str
    files: List


class CreateInquiryAttachmentDto(BaseModel):
    inquiry_id: int
    uuid: str
    file_name: str
    path: str
    extension: str
    object_name: str
    origin_file: FileStorage
    is_upload: bool

    class Config:
        arbitrary_types_allowed = True
