from typing import List

from pydantic import BaseModel, StrictStr, StrictInt

from core.domains.plant.entity.plant_entity import (
    MainPlantInfoEntity,
    WeeklyPlantEntity,
    MonthlyPlantEntity,
)


class GetPlantCategoryBaseSchema(BaseModel):
    id: StrictInt
    name: StrictStr


class GetPlantCategoryResponseSchema(BaseModel):
    categories: List[GetPlantCategoryBaseSchema]


class GetPlantMainBaseSchema(BaseModel):
    name: StrictStr
    start_growing_date: StrictStr
    start_growing_diff_date: StrictStr


class GetPlantDetailBaseSchema(BaseModel):
    name: StrictStr


class GetPlantMainResponseSchema(BaseModel):
    plant_profile: GetPlantMainBaseSchema
    plant_info: MainPlantInfoEntity | None


class GetPlantDetailResponseSchema(BaseModel):
    plant_profile: GetPlantDetailBaseSchema
    plant_info: MainPlantInfoEntity | None
    weekly_plant_info: List[WeeklyPlantEntity]
    monthly_plant_info: List[MonthlyPlantEntity]
