from datetime import datetime
from typing import List

from pydantic import BaseModel, UUID4

from core.domains.plant.entity.plant_entity import PlantProfileEntity


class DeviceEntity(BaseModel):
    id: int
    user_id: int
    mobile_os: str
    hw_mac: str | None


class NotificationTokenEntity(BaseModel):
    id: int
    user_id: int
    token: str | None
    endpoint: str | None


class ReceivePushTypeEntity(BaseModel):
    is_comment: bool
    is_like: bool
    is_incubator: bool


class UserProfileEntity(BaseModel):
    id: int
    user_id: int
    uuid: str | None
    file_name: str | None
    path: str | None
    extension: str | None
    is_available: bool


class JwtEntity(BaseModel):
    id: int
    user_id: int
    access_token: str
    refresh_token: str
    access_expired_at: datetime
    refresh_expired_at: datetime


class BlacklistEntity(BaseModel):
    id: int
    user_id: int
    access_token: str
    expired_at: datetime


class UserEntity(BaseModel):
    id: int
    email: str | None
    join_date: str
    provider: str
    provider_id: str | None
    group: str
    nickname: str
    is_out: bool
    is_available: bool
    current_connection_time: datetime
    uuid: str | None
    device: DeviceEntity
    notification_token: NotificationTokenEntity
    receive_push_type: ReceivePushTypeEntity
    user_profile: UserProfileEntity | None
    jwt: JwtEntity
    blacklists: List[BlacklistEntity] | None
    plant_profile: PlantProfileEntity
