"""create schema skeleton

Revision ID: a194da2529f5
Revises: 
Create Date: 2022-07-22 10:43:30.198108

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "a194da2529f5"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        "app_agree_terms",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("user_id", sa.BigInteger(), nullable=False),
        sa.Column("private_user_info_yn", sa.Boolean(), nullable=False),
        sa.Column("required_terms_yn", sa.Boolean(), nullable=False),
        sa.Column("receive_marketing_yn", sa.Boolean(), nullable=False),
        sa.Column("update_receive_marketing_at", sa.DateTime(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_app_agree_terms_user_id"), "app_agree_terms", ["user_id"], unique=True
    )
    op.create_table(
        "banned_words",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("word", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "customer_inquiries",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "user_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=True,
        ),
        sa.Column("email", sa.String(length=75), nullable=False),
        sa.Column("title", sa.String(length=100), nullable=False),
        sa.Column("body", sa.Text(), nullable=False),
        sa.Column("is_solved", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_customer_inquiries_user_id"),
        "customer_inquiries",
        ["user_id"],
        unique=False,
    )
    op.create_table(
        "notifications",
        sa.Column(
            "id", sa.BigInteger().with_variant(sa.Integer(), "sqlite"), nullable=False
        ),
        sa.Column("user_id", sa.BigInteger(), nullable=False),
        sa.Column("token", sa.String(length=170), nullable=False),
        sa.Column("endpoint", sa.String(length=100), nullable=True),
        sa.Column("uuid", sa.String(length=36), nullable=True),
        sa.Column("topic", sa.String(length=10), nullable=False),
        sa.Column("status", sa.String(length=5), nullable=False),
        sa.Column(
            "message",
            postgresql.JSONB(astext_type=sa.Text()).with_variant(sa.JSON(), "sqlite"),
            nullable=False,
        ),
        sa.Column("is_read", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_notifications_status"), "notifications", ["status"], unique=False
    )
    op.create_index(
        op.f("ix_notifications_topic"), "notifications", ["topic"], unique=False
    )
    op.create_index(
        op.f("ix_notifications_user_id"), "notifications", ["user_id"], unique=False
    )
    op.create_table(
        "plant_categories",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("name", sa.String(length=10), nullable=False),
        sa.Column("is_available", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "post_categories",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("name", sa.String(length=30), nullable=False),
        sa.Column("is_available", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "receive_failure_histories",
        sa.Column(
            "id", sa.BigInteger().with_variant(sa.Integer(), "sqlite"), nullable=False
        ),
        sa.Column("sensormac", sa.String(length=30), nullable=True),
        sa.Column(
            "receive_data",
            postgresql.JSONB(astext_type=sa.Text()).with_variant(sa.JSON(), "sqlite"),
            nullable=False,
        ),
        sa.Column("reason", sa.Text(), nullable=True),
        sa.Column("created_date", sa.String(length=8), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "users",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("email", sa.String(length=75), nullable=True),
        sa.Column("join_date", sa.String(length=8), nullable=False),
        sa.Column("provider", sa.String(length=10), nullable=False),
        sa.Column("provider_id", sa.String(length=256), nullable=False),
        sa.Column("group", sa.String(length=10), nullable=False),
        sa.Column("nickname", sa.String(length=10), nullable=False),
        sa.Column("is_out", sa.Boolean(), nullable=False),
        sa.Column("is_available", sa.Boolean(), nullable=False),
        sa.Column(
            "current_connection_time",
            sa.DateTime(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "blacklists",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("user_id", sa.BigInteger(), nullable=False),
        sa.Column("access_token", sa.String(length=280), nullable=False),
        sa.Column("expired_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_blacklists_user_id"), "blacklists", ["user_id"], unique=False
    )
    op.create_table(
        "devices",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("user_id", sa.BigInteger(), nullable=False),
        sa.Column("mobile_os", sa.String(length=3), nullable=False),
        sa.Column("hw_mac", sa.String(length=100), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_devices_user_id"), "devices", ["user_id"], unique=True)
    op.create_index(op.f("ix_devices_hw_mac"), "devices", ["hw_mac"], unique=True)
    op.create_table(
        "inquiry_attachments",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "inquiry_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("uuid", sa.String(length=100), nullable=False),
        sa.Column("file_name", sa.String(length=100), nullable=False),
        sa.Column("path", sa.String(length=300), nullable=False),
        sa.Column("extension", sa.String(length=5), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["inquiry_id"], ["customer_inquiries.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_inquiry_attachments_inquiry_id"),
        "inquiry_attachments",
        ["inquiry_id"],
        unique=False,
    )
    op.create_table(
        "jwts",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("user_id", sa.BigInteger(), nullable=False),
        sa.Column("access_token", sa.String(length=280), nullable=False),
        sa.Column("refresh_token", sa.String(length=280), nullable=False),
        sa.Column("access_expired_at", sa.DateTime(), nullable=False),
        sa.Column("refresh_expired_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_jwts_user_id"), "jwts", ["user_id"], unique=False)
    op.create_table(
        "notification_tokens",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("user_id", sa.BigInteger(), nullable=False),
        sa.Column("token", sa.String(length=170), nullable=True),
        sa.Column("endpoint", sa.String(length=100), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_notification_tokens_user_id"),
        "notification_tokens",
        ["user_id"],
        unique=True,
    )
    op.create_table(
        "plant_profiles",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "user_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("name", sa.String(length=50), nullable=False),
        sa.Column("start_growing_date", sa.String(length=8), nullable=False),
        sa.Column("plant_category_id", sa.SmallInteger(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["plant_category_id"], ["plant_categories.id"],),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_plant_profiles_plant_category_id"),
        "plant_profiles",
        ["plant_category_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_plant_profiles_user_id"), "plant_profiles", ["user_id"], unique=True
    )
    op.create_table(
        "posts",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "user_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("title", sa.String(length=100), nullable=True),
        sa.Column("body", sa.Text(), nullable=False),
        sa.Column("is_deleted", sa.Boolean(), nullable=False),
        sa.Column("like_count", sa.Integer(), nullable=False),
        sa.Column("post_category_id", sa.SmallInteger(), nullable=False),
        sa.Column("last_user_action", sa.String(length=20), nullable=False),
        sa.Column(
            "last_user_action_at",
            sa.DateTime(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("last_admin_action", sa.String(length=20), nullable=True),
        sa.Column("last_admin_action_at", sa.DateTime(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["post_category_id"], ["post_categories.id"],),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_posts_post_category_id"), "posts", ["post_category_id"], unique=False
    )
    op.create_index(op.f("ix_posts_user_id"), "posts", ["user_id"], unique=False)
    op.create_table(
        "receive_push_types",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("user_id", sa.BigInteger(), nullable=False),
        sa.Column("is_comment", sa.Boolean(), nullable=False),
        sa.Column("is_like", sa.Boolean(), nullable=False),
        sa.Column("is_incubator", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_receive_push_types_user_id"),
        "receive_push_types",
        ["user_id"],
        unique=True,
    )
    op.create_table(
        "user_profiles",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "user_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("uuid", sa.String(length=100), nullable=False),
        sa.Column("file_name", sa.String(length=100), nullable=False),
        sa.Column("path", sa.String(length=300), nullable=False),
        sa.Column("extension", sa.String(length=5), nullable=False),
        sa.Column("is_available", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["user_id"], ["users.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_user_profiles_user_id"), "user_profiles", ["user_id"], unique=True
    )
    op.create_table(
        "comments",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "post_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column(
            "user_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("body", sa.Text(), nullable=False),
        sa.Column("is_deleted", sa.Boolean(), nullable=False),
        sa.Column("like_count", sa.Integer(), nullable=False),
        sa.Column("last_user_action", sa.String(length=20), nullable=False),
        sa.Column(
            "last_user_action_at",
            sa.DateTime(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.Column("last_admin_action", sa.String(length=20), nullable=True),
        sa.Column("last_admin_action_at", sa.DateTime(), nullable=True),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["post_id"], ["posts.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_comments_post_id"), "comments", ["post_id"], unique=False)
    op.create_index(op.f("ix_comments_user_id"), "comments", ["user_id"], unique=False)
    op.create_table(
        "plant_infos",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "plant_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("sensormac", sa.String(length=30), nullable=False),
        sa.Column("interrupt", sa.String(length=100), nullable=False),
        sa.Column("temperature", sa.Numeric(precision=4, scale=1), nullable=False),
        sa.Column("indoor_humidity", sa.Numeric(precision=4, scale=1), nullable=False),
        sa.Column("soil_humidity", sa.Numeric(precision=4, scale=1), nullable=False),
        sa.Column("illuminance", sa.Numeric(precision=4, scale=1), nullable=False),
        sa.Column("created_date", sa.String(length=8), nullable=False),
        sa.Column("created_time", sa.String(length=4), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["plant_id"], ["plant_profiles.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_plant_infos_created_date"),
        "plant_infos",
        ["created_date"],
        unique=False,
    )
    op.create_index(
        op.f("ix_plant_infos_plant_id"), "plant_infos", ["plant_id"], unique=False
    )
    op.create_table(
        "post_attachments",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "post_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("uuid", sa.String(length=100), nullable=False),
        sa.Column("file_name", sa.String(length=100), nullable=False),
        sa.Column("path", sa.String(length=300), nullable=False),
        sa.Column("extension", sa.String(length=5), nullable=False),
        sa.Column("is_available", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["post_id"], ["posts.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_post_attachments_post_id"),
        "post_attachments",
        ["post_id"],
        unique=False,
    )
    op.create_table(
        "post_like_statuses",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "post_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column(
            "user_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("is_liked", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["post_id"], ["posts.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_post_like_statuses_post_id"),
        "post_like_statuses",
        ["post_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_post_like_statuses_user_id"),
        "post_like_statuses",
        ["user_id"],
        unique=False,
    )
    op.create_table(
        "comment_like_statuses",
        sa.Column(
            "id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "comment_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column(
            "user_id",
            sa.BigInteger().with_variant(sa.Integer(), "sqlite"),
            nullable=False,
        ),
        sa.Column("is_liked", sa.Boolean(), nullable=False),
        sa.Column(
            "created_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.Column(
            "updated_at", sa.DateTime(), server_default=sa.text("now()"), nullable=False
        ),
        sa.ForeignKeyConstraint(["comment_id"], ["comments.id"],),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_comment_like_statuses_comment_id"),
        "comment_like_statuses",
        ["comment_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_comment_like_statuses_user_id"),
        "comment_like_statuses",
        ["user_id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_comment_like_statuses_user_id"), table_name="comment_like_statuses"
    )
    op.drop_index(
        op.f("ix_comment_like_statuses_comment_id"), table_name="comment_like_statuses"
    )
    op.drop_table("comment_like_statuses")
    op.drop_index(
        op.f("ix_post_like_statuses_user_id"), table_name="post_like_statuses"
    )
    op.drop_index(
        op.f("ix_post_like_statuses_post_id"), table_name="post_like_statuses"
    )
    op.drop_table("post_like_statuses")
    op.drop_index(op.f("ix_post_attachments_post_id"), table_name="post_attachments")
    op.drop_table("post_attachments")
    op.drop_index(op.f("ix_plant_infos_plant_id"), table_name="plant_infos")
    op.drop_index(op.f("ix_plant_infos_created_date"), table_name="plant_infos")
    op.drop_table("plant_infos")
    op.drop_index(op.f("ix_comments_user_id"), table_name="comments")
    op.drop_index(op.f("ix_comments_post_id"), table_name="comments")
    op.drop_table("comments")
    op.drop_index(op.f("ix_user_profiles_user_id"), table_name="user_profiles")
    op.drop_table("user_profiles")
    op.drop_index(
        op.f("ix_receive_push_types_user_id"), table_name="receive_push_types"
    )
    op.drop_table("receive_push_types")
    op.drop_index(op.f("ix_posts_user_id"), table_name="posts")
    op.drop_index(op.f("ix_posts_post_category_id"), table_name="posts")
    op.drop_table("posts")
    op.drop_index(op.f("ix_plant_profiles_user_id"), table_name="plant_profiles")
    op.drop_index(
        op.f("ix_plant_profiles_plant_category_id"), table_name="plant_profiles"
    )
    op.drop_table("plant_profiles")
    op.drop_index(
        op.f("ix_notification_tokens_user_id"), table_name="notification_tokens"
    )
    op.drop_table("notification_tokens")
    op.drop_index(op.f("ix_jwts_user_id"), table_name="jwts")
    op.drop_table("jwts")
    op.drop_index(
        op.f("ix_inquiry_attachments_inquiry_id"), table_name="inquiry_attachments"
    )
    op.drop_table("inquiry_attachments")
    op.drop_index(op.f("ix_devices_user_id"), table_name="devices")
    op.drop_table("devices")
    op.drop_index(op.f("ix_blacklists_user_id"), table_name="blacklists")
    op.drop_table("blacklists")
    op.drop_table("users")
    op.drop_table("receive_failure_histories")
    op.drop_table("post_categories")
    op.drop_table("plant_categories")
    op.drop_index(op.f("ix_notifications_user_id"), table_name="notifications")
    op.drop_index(op.f("ix_notifications_topic"), table_name="notifications")
    op.drop_index(op.f("ix_notifications_status"), table_name="notifications")
    op.drop_table("notifications")
    op.drop_index(
        op.f("ix_customer_inquiries_user_id"), table_name="customer_inquiries"
    )
    op.drop_table("customer_inquiries")
    op.drop_table("banned_words")
    op.drop_index(op.f("ix_app_agree_terms_user_id"), table_name="app_agree_terms")
    op.drop_table("app_agree_terms")
    # ### end Alembic commands ###
