from app.persistence.model.user_model import UserModel
from core.domains.user.repository.user_repository import UserRepository


def test_default_cicd_pipeline_success(create_user):
    user = create_user
    assert isinstance(user, UserModel)


def test_update_user_status_to_out_when_user_want_member_out_then_is_out_should_true(
    db, session, create_user
):
    UserRepository().update_user_is_out(user_id=create_user.id, status=True)

    # create new session
    connection = db.engine.connect()
    options = dict(bind=connection, binds={})

    session_2 = db.create_scoped_session(options=options)

    user = session_2.query(UserModel).filter_by(id=create_user.id).first()

    assert user.is_out is True

    session_2.remove()
