import inject

from core.domains.community.repository.community_repository import CommunityRepository
from core.domains.cs.repository.cs_repository import CSRepository
from core.domains.iot.repository.iot_repository import IOTRepository
from core.domains.notification.repository.notification_repository import (
    NotificationRepository,
)
from core.domains.plant.repository.plant_repository import PlantRepository
from core.domains.user.repository.user_repository import UserRepository


def bind(binder, app):
    binder.bind_to_provider(IOTRepository, IOTRepository)
    binder.bind_to_provider(UserRepository, UserRepository)
    binder.bind_to_provider(CommunityRepository, CommunityRepository)
    binder.bind_to_provider(PlantRepository, PlantRepository)
    binder.bind_to_provider(CSRepository, CSRepository)
    binder.bind_to_provider(NotificationRepository, NotificationRepository)


def init_provider(app):
    inject.clear_and_configure(lambda binder: bind(binder, app))
