from flask import current_app
from pyfcm import FCMNotification

from app.extensions.utils.log_helper import logger_

logger = logger_.getLogger(__name__)


class FCM:
    @classmethod
    def send_message(
        cls, title: str | None, body: str, token: str, data: dict | None
    ) -> bool:
        API_KEY = current_app.config.get("FCM_API_KEY")
        try:
            push_service = FCMNotification(API_KEY)

            # 토큰값을 이용해 1명에게 푸시알림을 전송함
            result = push_service.notify_single_device(
                registration_id=token,
                message_title=title,
                message_body=body,
                data_message=data,
            )

            if result.get("failure") == 1:
                return False

            return True
        except Exception as e:
            logger.error(f"[FCM][send_message] error : {e}")

        return False
