from http import HTTPStatus

from flask import request
from flask_jwt_extended import jwt_required

from app.http.requests.v1.cs_request import CreateCSRequest
from app.http.responses import failure_response
from app.http.responses.presenters.v1.cs_presenter import CreateCSPresenter
from app.http.view import api, auth_required
from app.http.view.authentication import current_user
from core.domains.cs.dto.cs_dto import CreateCustomerInquiryDto
from core.domains.cs.use_case.v1.cs_use_case import CreateCSUseCase
from core.use_case_output import UseCaseFailureOutput, FailureType


@api.route("/v1/cs", methods=["POST"])
@jwt_required
@auth_required
def create_cs():
    try:
        dto: CreateCustomerInquiryDto = CreateCSRequest(
            **request.form.to_dict(),
            files=request.files.getlist("files"),
            user_id=current_user.id,
        ).validate_request_and_make_dto()
        return CreateCSPresenter().transform(CreateCSUseCase().execute(dto=dto))
    except Exception as e:
        return failure_response(
            UseCaseFailureOutput(
                type=f"[create_cs] Unexpected error: {e}",
                message=FailureType.INTERNAL_ERROR,
                code=HTTPStatus.INTERNAL_SERVER_ERROR,
            )
        )
