from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    String,
    DateTime,
    func,
    ForeignKey,
    Boolean,
)

from app import db
from app.persistence.model.post_model import PostModel
from core.domains.community.entity.community_entity import PostAttachmentEntity


class PostAttachmentModel(db.Model):
    __tablename__ = "post_attachments"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    post_id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        ForeignKey(PostModel.id),
        nullable=False,
        index=True,
    )
    uuid = Column(String(100), nullable=False)
    file_name = Column(String(100), nullable=False)
    path = Column(String(300), nullable=False)
    extension = Column(String(5), nullable=False)
    is_available = Column(Boolean, nullable=False, default=True)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
    updated_at = Column(
        DateTime(), server_default=func.now(), onupdate=func.now(), nullable=False
    )

    def to_entity(self) -> PostAttachmentEntity:
        return PostAttachmentEntity(
            id=self.id,
            post_id=self.post_id,
            uuid=self.uuid,
            file_name=self.file_name,
            path=self.path,
            extension=self.extension,
            is_available=self.is_available,
            created_at=self.created_at,
            updated_at=self.updated_at,
        )
