from sqlalchemy import (
    Column,
    BigInteger,
    DateTime,
    Integer,
    String,
    func,
    JSON,
    Text,
)
from sqlalchemy.dialects.postgresql import JSONB

from app import db


class ReceiveFailureHistoryModel(db.Model):
    __tablename__ = "receive_failure_histories"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"), primary_key=True, nullable=False
    )
    sensormac = Column(String(30), nullable=True)
    receive_data = Column(
        "receive_data", JSONB().with_variant(JSON, "sqlite"), nullable=False, default={}
    )
    reason = Column(Text, nullable=True)
    created_date = Column(String(8), nullable=True)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
