from sqlalchemy import (
    Column,
    BigInteger,
    Integer,
    ForeignKey,
    DateTime,
    Boolean,
    func,
)

from app import db
from app.persistence.model.user_model import UserModel
from core.domains.user.entity.user_entity import ReceivePushTypeEntity


class ReceivePushTypeModel(db.Model):
    __tablename__ = "receive_push_types"

    id = Column(
        BigInteger().with_variant(Integer, "sqlite"),
        primary_key=True,
        nullable=False,
        autoincrement=True,
    )
    user_id = Column(
        BigInteger, ForeignKey(UserModel.id), nullable=False, unique=True, index=True,
    )
    is_comment = Column(Boolean, nullable=False, default=True)
    is_like = Column(Boolean, nullable=False, default=True)
    is_incubator = Column(Boolean, nullable=False, default=True)
    created_at = Column(DateTime(), server_default=func.now(), nullable=False)
    updated_at = Column(
        DateTime(), server_default=func.now(), onupdate=func.now(), nullable=False
    )

    def to_entity(self) -> ReceivePushTypeEntity:
        return ReceivePushTypeEntity(
            is_comment=self.is_comment,
            is_like=self.is_like,
            is_incubator=self.is_incubator,
        )
