from datetime import datetime
from typing import List

from pydantic import BaseModel


class PlantInfoEntity(BaseModel):
    id: int
    plant_id: int
    sensormac: str
    interrupt: str | None
    temperature: float
    indoor_humidity: float
    soil_humidity: float
    illuminance: float
    created_date: str
    created_time: str
    created_at: datetime


class PlantProfileEntity(BaseModel):
    id: int
    user_id: int
    name: str
    start_growing_date: str
    start_growing_diff_date: str | None
    plant_category_id: int
    plant_infos: List[PlantInfoEntity] | None


class PlantCategoryEntity(BaseModel):
    id: int
    name: str


class MainPlantInfoEntity(BaseModel):
    div: str
    plant_status_1: str | None
    plant_status_2: str | None
    div_data: float


class WeeklyPlantEntity(BaseModel):
    day: str | None
    div_data: float | None


class MonthlyPlantEntity(BaseModel):
    month: str | None
    div_data: float | None
