from typing import List

from pydantic import BaseModel, StrictStr, StrictInt, StrictBool


class DefaultUserResponseSchema(BaseModel):
    result: StrictStr


class UploadUserProfileImgResponseSchema(BaseModel):
    uuid: StrictStr
    file_name: StrictStr
    path: StrictStr
    extension: StrictStr


class GetUserProfileBaseSchema(BaseModel):
    id: StrictInt
    path: StrictStr


class GetUserPlantProfileBaseSchema(BaseModel):
    name: StrictStr
    start_growing_date: StrictStr
    plant_category_id: StrictInt


class GetUserBaseSchema(BaseModel):
    nickname: StrictStr
    user_profile: GetUserProfileBaseSchema | None
    plant_profile: GetUserPlantProfileBaseSchema


class GetUserPlantCategoryBaseSchema(BaseModel):
    id: StrictInt
    name: StrictStr


class GetUserResponseSchema(BaseModel):
    user: GetUserBaseSchema
    plant_categories: List[GetUserPlantCategoryBaseSchema]


class GetReceivePushTypeBaseSchema(BaseModel):
    is_comment: StrictBool
    is_like: StrictBool
    is_incubator: StrictBool


class GetReceivePushTypeResponseSchema(BaseModel):
    receive_push_type: GetReceivePushTypeBaseSchema


class CreateUserResponseSchema(BaseModel):
    access_token: str


class GetMacResponseSchema(BaseModel):
    hw_mac: StrictStr | None
