import io

import pytest
from werkzeug.datastructures import FileStorage

from app.http.requests.v1.cs_request import CreateCSRequest
from core.exceptions import InvalidRequestException
from tests.seeder.conftest import faker


def test_create_cs_image_upload_request_should_limit_format(create_user):
    test_image_1 = FileStorage(
        stream=io.BytesIO(b"aaa"),
        filename=f"test.png",
        content_type="multipart/form-data",
    )

    test_image_2 = FileStorage(
        stream=io.BytesIO(b"aaa"),
        filename=f"test.jpg",
        content_type="multipart/form-data",
    )

    test_image_3 = FileStorage(
        stream=io.BytesIO(b"aaa"),
        filename=f"test.jpeg",
        content_type="multipart/form-data",
    )
    files: list = [test_image_1, test_image_2, test_image_3]

    result = CreateCSRequest(
        user_id=create_user.id,
        title=faker.sentence(),
        email=faker.email(),
        body=faker.sentence(),
        files=files,
    ).validate_request_and_make_dto()

    for result_file, test_file in zip(result.files, files):
        assert result_file == test_file


def test_create_cs_image_upload_request_should_fail_when_wrong_format(create_user):
    test_image_1 = FileStorage(
        stream=io.BytesIO(b"aaa"),
        filename=f"test.txt",
        content_type="multipart/form-data",
    )

    test_image_2 = FileStorage(
        stream=io.BytesIO(b"aaa"),
        filename=f"test.png",
        content_type="multipart/form-data",
    )

    test_image_3 = FileStorage(
        stream=io.BytesIO(b"aaa"),
        filename=f"test.jpg",
        content_type="multipart/form-data",
    )
    files: list = [test_image_1, test_image_2, test_image_3]

    with pytest.raises(InvalidRequestException):
        CreateCSRequest(
            user_id=create_user.id,
            title=faker.sentence(),
            email=faker.email(),
            body=faker.sentence(),
            files=files,
        ).validate_request_and_make_dto()
