/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.datamatrix.DataMatrixReader;
import com.google.zxing.oned.MultiFormatOneDReader;
import com.google.zxing.pdf417.PDF417Reader;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiFormatReader
implements Reader {
    private Hashtable hints;
    private Vector readers;

    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException {
        this.setHints(null);
        return this.decodeInternal(binaryBitmap);
    }

    public Result decode(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException {
        this.setHints(hashtable);
        return this.decodeInternal(binaryBitmap);
    }

    public Result decodeWithState(BinaryBitmap binaryBitmap) throws NotFoundException {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(binaryBitmap);
    }

    public void setHints(Hashtable hashtable) {
        this.hints = hashtable;
        boolean bl = hashtable != null && hashtable.containsKey(DecodeHintType.TRY_HARDER);
        Vector vector = hashtable == null ? null : (Vector)hashtable.get(DecodeHintType.POSSIBLE_FORMATS);
        this.readers = new Vector();
        if (vector != null) {
            boolean bl2;
            boolean bl3 = bl2 = vector.contains(BarcodeFormat.UPC_A) || vector.contains(BarcodeFormat.UPC_E) || vector.contains(BarcodeFormat.EAN_13) || vector.contains(BarcodeFormat.EAN_8) || vector.contains(BarcodeFormat.CODE_39) || vector.contains(BarcodeFormat.CODE_93) || vector.contains(BarcodeFormat.CODE_128) || vector.contains(BarcodeFormat.ITF) || vector.contains(BarcodeFormat.RSS14) || vector.contains(BarcodeFormat.RSS_EXPANDED);
            if (bl2 && !bl) {
                this.readers.addElement(new MultiFormatOneDReader(hashtable));
            }
            if (vector.contains(BarcodeFormat.QR_CODE)) {
                this.readers.addElement(new QRCodeReader());
            }
            if (vector.contains(BarcodeFormat.DATA_MATRIX)) {
                this.readers.addElement(new DataMatrixReader());
            }
            if (vector.contains(BarcodeFormat.PDF417)) {
                this.readers.addElement(new PDF417Reader());
            }
            if (bl2 && bl) {
                this.readers.addElement(new MultiFormatOneDReader(hashtable));
            }
        }
        if (this.readers.isEmpty()) {
            if (!bl) {
                this.readers.addElement(new MultiFormatOneDReader(hashtable));
            }
            this.readers.addElement(new QRCodeReader());
            this.readers.addElement(new DataMatrixReader());
            if (bl) {
                this.readers.addElement(new MultiFormatOneDReader(hashtable));
            }
        }
    }

    public void reset() {
        int n = this.readers.size();
        for (int i = 0; i < n; ++i) {
            Reader reader = (Reader)this.readers.elementAt(i);
            reader.reset();
        }
    }

    private Result decodeInternal(BinaryBitmap binaryBitmap) throws NotFoundException {
        int n = this.readers.size();
        for (int i = 0; i < n; ++i) {
            Reader reader = (Reader)this.readers.elementAt(i);
            try {
                return reader.decode(binaryBitmap, this.hints);
            }
            catch (ReaderException readerException) {
                continue;
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

