/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.oned.Code39Writer;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.EAN8Writer;
import com.google.zxing.oned.ITFWriter;
import com.google.zxing.qrcode.QRCodeWriter;
import java.util.Hashtable;

public final class MultiFormatWriter
implements Writer {
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) throws WriterException {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        Writer writer;
        if (barcodeFormat == BarcodeFormat.EAN_8) {
            writer = new EAN8Writer();
        } else if (barcodeFormat == BarcodeFormat.EAN_13) {
            writer = new EAN13Writer();
        } else if (barcodeFormat == BarcodeFormat.QR_CODE) {
            writer = new QRCodeWriter();
        } else if (barcodeFormat == BarcodeFormat.CODE_39) {
            writer = new Code39Writer();
        } else if (barcodeFormat == BarcodeFormat.CODE_128) {
            writer = new Code128Writer();
        } else if (barcodeFormat == BarcodeFormat.ITF) {
            writer = new ITFWriter();
        } else {
            throw new IllegalArgumentException("No encoder available for format " + barcodeFormat);
        }
        return writer.encode(string, barcodeFormat, n, n2, hashtable);
    }
}

