/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Result {
    private final String text;
    private final byte[] rawBytes;
    private ResultPoint[] resultPoints;
    private final BarcodeFormat format;
    private Hashtable resultMetadata;
    private final long timestamp;

    public Result(String string, byte[] byArray, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat) {
        this(string, byArray, resultPointArray, barcodeFormat, System.currentTimeMillis());
    }

    public Result(String string, byte[] byArray, ResultPoint[] resultPointArray, BarcodeFormat barcodeFormat, long l) {
        if (string == null && byArray == null) {
            throw new IllegalArgumentException("Text and bytes are null");
        }
        this.text = string;
        this.rawBytes = byArray;
        this.resultPoints = resultPointArray;
        this.format = barcodeFormat;
        this.resultMetadata = null;
        this.timestamp = l;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public ResultPoint[] getResultPoints() {
        return this.resultPoints;
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.format;
    }

    public Hashtable getResultMetadata() {
        return this.resultMetadata;
    }

    public void putMetadata(ResultMetadataType resultMetadataType, Object object) {
        if (this.resultMetadata == null) {
            this.resultMetadata = new Hashtable(3);
        }
        this.resultMetadata.put(resultMetadataType, object);
    }

    public void putAllMetadata(Hashtable hashtable) {
        if (hashtable != null) {
            if (this.resultMetadata == null) {
                this.resultMetadata = hashtable;
            } else {
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    ResultMetadataType resultMetadataType = (ResultMetadataType)enumeration.nextElement();
                    Object v = hashtable.get(resultMetadataType);
                    this.resultMetadata.put(resultMetadataType, v);
                }
            }
        }
    }

    public void addResultPoints(ResultPoint[] resultPointArray) {
        if (this.resultPoints == null) {
            this.resultPoints = resultPointArray;
        } else if (resultPointArray != null && resultPointArray.length > 0) {
            ResultPoint[] resultPointArray2 = new ResultPoint[this.resultPoints.length + resultPointArray.length];
            System.arraycopy(this.resultPoints, 0, resultPointArray2, 0, this.resultPoints.length);
            System.arraycopy(resultPointArray, 0, resultPointArray2, this.resultPoints.length, resultPointArray.length);
            this.resultPoints = resultPointArray2;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        if (this.text == null) {
            return "[" + this.rawBytes.length + " bytes]";
        }
        return this.text;
    }
}

