/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;

public final class CalendarParsedResult
extends ParsedResult {
    private final String summary;
    private final String start;
    private final String end;
    private final String location;
    private final String attendee;
    private final String description;

    public CalendarParsedResult(String string, String string2, String string3, String string4, String string5, String string6) {
        super(ParsedResultType.CALENDAR);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        CalendarParsedResult.validateDate(string2);
        if (string3 == null) {
            string3 = string2;
        } else {
            CalendarParsedResult.validateDate(string3);
        }
        this.summary = string;
        this.start = string2;
        this.end = string3;
        this.location = string4;
        this.attendee = string5;
        this.description = string6;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAttendee() {
        return this.attendee;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayResult() {
        StringBuffer stringBuffer = new StringBuffer(100);
        CalendarParsedResult.maybeAppend(this.summary, stringBuffer);
        CalendarParsedResult.maybeAppend(this.start, stringBuffer);
        CalendarParsedResult.maybeAppend(this.end, stringBuffer);
        CalendarParsedResult.maybeAppend(this.location, stringBuffer);
        CalendarParsedResult.maybeAppend(this.attendee, stringBuffer);
        CalendarParsedResult.maybeAppend(this.description, stringBuffer);
        return stringBuffer.toString();
    }

    private static void validateDate(String string) {
        if (string != null) {
            int n;
            int n2 = string.length();
            if (n2 != 8 && n2 != 15 && n2 != 16) {
                throw new IllegalArgumentException();
            }
            for (n = 0; n < 8; ++n) {
                if (Character.isDigit(string.charAt(n))) continue;
                throw new IllegalArgumentException();
            }
            if (n2 > 8) {
                if (string.charAt(8) != 'T') {
                    throw new IllegalArgumentException();
                }
                for (n = 9; n < 15; ++n) {
                    if (Character.isDigit(string.charAt(n))) continue;
                    throw new IllegalArgumentException();
                }
                if (n2 == 16 && string.charAt(15) != 'Z') {
                    throw new IllegalArgumentException();
                }
            }
        }
    }
}

